// Function to get URL parameters
function getUTMParameters() {  // Changed from getUrlParameters to getUTMParameters
    const urlParams = new URLSearchParams(window.location.search);
    return {
        utm_campaign: urlParams.get('utm_campaign') || 'not_set',
        utm_content: urlParams.get('utm_content') || 'not_set',
        utm_medium: urlParams.get('utm_medium') || 'not_set',
        utm_source: urlParams.get('utm_source') || 'not_set',
        subid: urlParams.get('subid') || 'not_set'
    };
}

let selectedDebtAmount = '';

$(document).ready(function () {
    console.log("URL Parameters:", getUTMParameters());
      // First question handler (15k threshold)
      $('.debt-button').on('click', function () {
          const debtAmount = $(this).data('debt');
          if (debtAmount === '15k') {
              selectedDebtAmount = '15k';
              $('#question-1').hide();
              $('#question-2').show();
          } else {
              $('#question-1').hide();
              $('#question-1b').show();
          }
      });
    // Second question handler (10k threshold)
    $('.debt-button-10k').on('click', function () {
        const debtAmount = $(this).data('debt');
        if (debtAmount === '10k') {
            selectedDebtAmount = '10k';
        } else {
            selectedDebtAmount = '-10k';
        }
        $('#question-1b').hide();
        $('#question-2').show();
    });

    // Payment question handler
    $('.payment-button').on('click', function () {
        const paymentStatus = $(this).data('payment');
        handleRedirect(selectedDebtAmount, paymentStatus);
    });
});

function handleRedirect(debtAmount, paymentStatus = null) {
    const params = getUTMParameters();
    
    const queryString = Object.entries({
        ...params, 
        debt_amount: debtAmount,
        pay: paymentStatus
    })
        .map(([key, value]) => `${key}=${encodeURIComponent(value)}`)
        .join('&');
    window.location.href = `https://get.help-withdebt.com/base2.php?${queryString}`;
}